#version 330

uniform vec4 lightPosition;
uniform vec4 fogColor;
uniform float time;
uniform sampler2D skyMap;
uniform sampler3D cloudMap;
uniform sampler2D gradientMap;

in vec4 uv;
in vec3 norm;

out vec4 oColor;

void main() 
{
	float sun = clamp(dot(lightPosition.xyz, normalize(norm)), 0.0, 1.0);
    vec3 skyColor = textureLod(skyMap, uv.xy + vec2(time, 0), 0).rgb;
	oColor = vec4(skyColor + vec3(1, 0.75, 0.5) * clamp(pow(sun, 1500), 0.0, 1.0), 0.0);
	/*
	float cloudThickness = 0;
	vec3 cloudUvA = vec3(norm.xy*vec2(1, 1.5)/(norm.z + 0.080)*0.125 + uv.zw, time*4);
	vec3 cloudUvB = vec3(norm.xy*vec2(1, 1.5)/(norm.z + 0.100)*0.125 + uv.zw, time*4 + 1);
	vec3 cloudUvC = vec3(norm.xy*vec2(1, 1.5)/(norm.z + 0.120)*0.125 + uv.zw, time*4 + 2);
	//int i = 16;
	int i = 8;
	while(i >= 1) {
		cloudThickness += textureLod(cloudMap, cloudUvA, 0).r*i;
		cloudThickness += textureLod(cloudMap, cloudUvB, 0).r*i;
		cloudThickness += textureLod(cloudMap, cloudUvC, 0).r*i;
		cloudUvA *= 2.1;
		cloudUvB *= 2.1;
		cloudUvC *= 2.1;
		i /= 2;
	}
	//cloudThickness /= 31*3;
	cloudThickness /= 15*3;
	//cloudThickness = clamp(cloudThickness*2.0 - 1.0, 0.0, 1.0);
	
	vec4 cloudColor = textureLod(gradientMap, vec2(cloudThickness, pow(sun, 8)), 0);
	oColor = vec4(clamp(mix(skyColor.rgb, cloudColor.rgb, cloudColor.a), 0.0, 1.0), 1.0);
	oColor = mix(fogColor, oColor, clamp(1.0 - pow(1.0 - norm.z, 16), 0.0, 1.0));
	oColor += vec4(1, 0.75, 0.5, 0) * clamp(pow(sun, 2500) - pow(cloudColor.a, 3), 0.0, 1.0);
	*/
}
